/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AuthorizeSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeSecurityGroupIngressRequest>, AuthorizeSecurityGroupIngressRequest> {
    public Request<AuthorizeSecurityGroupIngressRequest> marshall(AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {
        if (authorizeSecurityGroupIngressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeSecurityGroupIngressRequest, "AmazonEC2");
        request.addParameter("Action", "AuthorizeSecurityGroupIngress");
        request.addParameter("Version", "2015-10-01");
        if (authorizeSecurityGroupIngressRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getGroupName()));
        }
        if (authorizeSecurityGroupIngressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getGroupId()));
        }
        if (authorizeSecurityGroupIngressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getSourceSecurityGroupName()));
        }
        if (authorizeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (authorizeSecurityGroupIngressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getIpProtocol()));
        }
        if (authorizeSecurityGroupIngressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequest.getFromPort()));
        }
        if (authorizeSecurityGroupIngressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequest.getToPort()));
        }
        if (authorizeSecurityGroupIngressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getCidrIp()));
        }
        List<IpPermission> ipPermissionsList = authorizeSecurityGroupIngressRequest.getIpPermissions();
        int ipPermissionsListIndex = 1;
        for (IpPermission ipPermissionsListValue : ipPermissionsList) {
            IpPermission ipPermissionMember = ipPermissionsListValue;
            if (ipPermissionMember != null) {
                if (ipPermissionMember.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)ipPermissionMember.getIpProtocol()));
                }
                if (ipPermissionMember.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)ipPermissionMember.getFromPort()));
                }
                if (ipPermissionMember.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)ipPermissionMember.getToPort()));
                }
                List<UserIdGroupPair> userIdGroupPairsList = ipPermissionMember.getUserIdGroupPairs();
                int userIdGroupPairsListIndex = 1;
                for (UserIdGroupPair userIdGroupPairsListValue : userIdGroupPairsList) {
                    UserIdGroupPair userIdGroupPairMember = userIdGroupPairsListValue;
                    if (userIdGroupPairMember != null) {
                        if (userIdGroupPairMember.getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)userIdGroupPairMember.getUserId()));
                        }
                        if (userIdGroupPairMember.getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)userIdGroupPairMember.getGroupName()));
                        }
                        if (userIdGroupPairMember.getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)userIdGroupPairMember.getGroupId()));
                        }
                        if (userIdGroupPairMember.getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)userIdGroupPairMember.getVpcId()));
                        }
                        if (userIdGroupPairMember.getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)userIdGroupPairMember.getVpcPeeringConnectionId()));
                        }
                        if (userIdGroupPairMember.getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)userIdGroupPairMember.getPeeringStatus()));
                        }
                    }
                    ++userIdGroupPairsListIndex;
                }
                List<String> ipRangesList = ipPermissionMember.getIpRanges();
                int ipRangesListIndex = 1;
                for (String ipRangesListValue : ipRangesList) {
                    if (ipRangesListValue != null) {
                        request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipRangesListIndex + ".CidrIp", StringUtils.fromString((String)ipRangesListValue));
                    }
                    ++ipRangesListIndex;
                }
                List<PrefixListId> prefixListIdsList = ipPermissionMember.getPrefixListIds();
                int prefixListIdsListIndex = 1;
                for (PrefixListId prefixListIdsListValue : prefixListIdsList) {
                    PrefixListId prefixListIdMember = prefixListIdsListValue;
                    if (prefixListIdMember != null && prefixListIdMember.getPrefixListId() != null) {
                        request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)prefixListIdMember.getPrefixListId()));
                    }
                    ++prefixListIdsListIndex;
                }
            }
            ++ipPermissionsListIndex;
        }
        return request;
    }
}

