/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.transform.EbsBlockDeviceStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class BlockDeviceMappingStaxUnmarshaller
implements Unmarshaller<BlockDeviceMapping, StaxUnmarshallerContext> {
    private static BlockDeviceMappingStaxUnmarshaller instance;

    public BlockDeviceMapping unmarshall(StaxUnmarshallerContext context) throws Exception {
        BlockDeviceMapping blockDeviceMapping = new BlockDeviceMapping();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return blockDeviceMapping;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("virtualName", targetDepth)) {
                    blockDeviceMapping.setVirtualName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("deviceName", targetDepth)) {
                    blockDeviceMapping.setDeviceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ebs", targetDepth)) {
                    blockDeviceMapping.setEbs(EbsBlockDeviceStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("noDevice", targetDepth)) continue;
                blockDeviceMapping.setNoDevice(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return blockDeviceMapping;
    }

    public static BlockDeviceMappingStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BlockDeviceMappingStaxUnmarshaller();
        }
        return instance;
    }
}

