/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.BundleTask;
import com.amazonaws.services.ec2.model.transform.BundleTaskErrorStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.StorageStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class BundleTaskStaxUnmarshaller
implements Unmarshaller<BundleTask, StaxUnmarshallerContext> {
    private static BundleTaskStaxUnmarshaller instance;

    public BundleTask unmarshall(StaxUnmarshallerContext context) throws Exception {
        BundleTask bundleTask = new BundleTask();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return bundleTask;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("instanceId", targetDepth)) {
                    bundleTask.setInstanceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("bundleId", targetDepth)) {
                    bundleTask.setBundleId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    bundleTask.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("startTime", targetDepth)) {
                    bundleTask.setStartTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("updateTime", targetDepth)) {
                    bundleTask.setUpdateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("storage", targetDepth)) {
                    bundleTask.setStorage(StorageStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("progress", targetDepth)) {
                    bundleTask.setProgress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("error", targetDepth)) continue;
                bundleTask.setBundleTaskError(BundleTaskErrorStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return bundleTask;
    }

    public static BundleTaskStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BundleTaskStaxUnmarshaller();
        }
        return instance;
    }
}

