/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class DescribeScheduledInstancesRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstancesRequest>, DescribeScheduledInstancesRequest> {
    public Request<DescribeScheduledInstancesRequest> marshall(DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {
        if (describeScheduledInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeScheduledInstances");
        request.addParameter("Version", "2015-10-01");
        List<String> scheduledInstanceIdsList = describeScheduledInstancesRequest.getScheduledInstanceIds();
        int scheduledInstanceIdsListIndex = 1;
        for (String scheduledInstanceIdsListValue : scheduledInstanceIdsList) {
            if (scheduledInstanceIdsListValue != null) {
                request.addParameter("ScheduledInstanceId." + scheduledInstanceIdsListIndex, StringUtils.fromString((String)scheduledInstanceIdsListValue));
            }
            ++scheduledInstanceIdsListIndex;
        }
        SlotStartTimeRangeRequest slotStartTimeRangeRequestSlotStartTimeRange = describeScheduledInstancesRequest.getSlotStartTimeRange();
        if (slotStartTimeRangeRequestSlotStartTimeRange != null) {
            if (slotStartTimeRangeRequestSlotStartTimeRange.getEarliestTime() != null) {
                request.addParameter("SlotStartTimeRange.EarliestTime", StringUtils.fromDate((Date)slotStartTimeRangeRequestSlotStartTimeRange.getEarliestTime()));
            }
            if (slotStartTimeRangeRequestSlotStartTimeRange.getLatestTime() != null) {
                request.addParameter("SlotStartTimeRange.LatestTime", StringUtils.fromDate((Date)slotStartTimeRangeRequestSlotStartTimeRange.getLatestTime()));
            }
        }
        if (describeScheduledInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScheduledInstancesRequest.getNextToken()));
        }
        if (describeScheduledInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeScheduledInstancesRequest.getMaxResults()));
        }
        List<Filter> filtersList = describeScheduledInstancesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

