/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ExportTask;
import com.amazonaws.services.ec2.model.transform.ExportToS3TaskStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.InstanceExportDetailsStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class ExportTaskStaxUnmarshaller
implements Unmarshaller<ExportTask, StaxUnmarshallerContext> {
    private static ExportTaskStaxUnmarshaller instance;

    public ExportTask unmarshall(StaxUnmarshallerContext context) throws Exception {
        ExportTask exportTask = new ExportTask();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return exportTask;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("exportTaskId", targetDepth)) {
                    exportTask.setExportTaskId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description", targetDepth)) {
                    exportTask.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    exportTask.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("statusMessage", targetDepth)) {
                    exportTask.setStatusMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceExport", targetDepth)) {
                    exportTask.setInstanceExportDetails(InstanceExportDetailsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("exportToS3", targetDepth)) continue;
                exportTask.setExportToS3Task(ExportToS3TaskStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return exportTask;
    }

    public static ExportTaskStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExportTaskStaxUnmarshaller();
        }
        return instance;
    }
}

