/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.HostProperties;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class HostPropertiesStaxUnmarshaller
implements Unmarshaller<HostProperties, StaxUnmarshallerContext> {
    private static HostPropertiesStaxUnmarshaller instance;

    public HostProperties unmarshall(StaxUnmarshallerContext context) throws Exception {
        HostProperties hostProperties = new HostProperties();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return hostProperties;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("sockets", targetDepth)) {
                    hostProperties.setSockets(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("cores", targetDepth)) {
                    hostProperties.setCores(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("totalVCpus", targetDepth)) {
                    hostProperties.setTotalVCpus(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceType", targetDepth)) continue;
                hostProperties.setInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return hostProperties;
    }

    public static HostPropertiesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HostPropertiesStaxUnmarshaller();
        }
        return instance;
    }
}

