/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.IdFormat;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class IdFormatStaxUnmarshaller
implements Unmarshaller<IdFormat, StaxUnmarshallerContext> {
    private static IdFormatStaxUnmarshaller instance;

    public IdFormat unmarshall(StaxUnmarshallerContext context) throws Exception {
        IdFormat idFormat = new IdFormat();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return idFormat;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("resource", targetDepth)) {
                    idFormat.setResource(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("useLongIds", targetDepth)) {
                    idFormat.setUseLongIds(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("deadline", targetDepth)) continue;
                idFormat.setDeadline(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return idFormat;
    }

    public static IdFormatStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IdFormatStaxUnmarshaller();
        }
        return instance;
    }
}

