/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceCapacity;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class InstanceCapacityStaxUnmarshaller
implements Unmarshaller<InstanceCapacity, StaxUnmarshallerContext> {
    private static InstanceCapacityStaxUnmarshaller instance;

    public InstanceCapacity unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceCapacity instanceCapacity = new InstanceCapacity();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return instanceCapacity;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("instanceType", targetDepth)) {
                    instanceCapacity.setInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availableCapacity", targetDepth)) {
                    instanceCapacity.setAvailableCapacity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("totalCapacity", targetDepth)) continue;
                instanceCapacity.setTotalCapacity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceCapacity;
    }

    public static InstanceCapacityStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceCapacityStaxUnmarshaller();
        }
        return instance;
    }
}

