/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceCount;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class InstanceCountStaxUnmarshaller
implements Unmarshaller<InstanceCount, StaxUnmarshallerContext> {
    private static InstanceCountStaxUnmarshaller instance;

    public InstanceCount unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceCount instanceCount = new InstanceCount();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return instanceCount;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("state", targetDepth)) {
                    instanceCount.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceCount", targetDepth)) continue;
                instanceCount.setInstanceCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceCount;
    }

    public static InstanceCountStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceCountStaxUnmarshaller();
        }
        return instance;
    }
}

