/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class InstanceStateStaxUnmarshaller
implements Unmarshaller<InstanceState, StaxUnmarshallerContext> {
    private static InstanceStateStaxUnmarshaller instance;

    public InstanceState unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceState instanceState = new InstanceState();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return instanceState;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("code", targetDepth)) {
                    instanceState.setCode(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("name", targetDepth)) continue;
                instanceState.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceState;
    }

    public static InstanceStateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceStateStaxUnmarshaller();
        }
        return instance;
    }
}

