/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.transform.PrefixListIdStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.UserIdGroupPairStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class IpPermissionStaxUnmarshaller
implements Unmarshaller<IpPermission, StaxUnmarshallerContext> {
    private static IpPermissionStaxUnmarshaller instance;

    public IpPermission unmarshall(StaxUnmarshallerContext context) throws Exception {
        IpPermission ipPermission = new IpPermission();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return ipPermission;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("ipProtocol", targetDepth)) {
                    ipPermission.setIpProtocol(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("fromPort", targetDepth)) {
                    ipPermission.setFromPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("toPort", targetDepth)) {
                    ipPermission.setToPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groups/item", targetDepth)) {
                    ipPermission.getUserIdGroupPairs().add(UserIdGroupPairStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipRanges/item/cidrIp", targetDepth)) {
                    ipPermission.getIpRanges().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("prefixListIds/item", targetDepth)) continue;
                ipPermission.getPrefixListIds().add(PrefixListIdStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return ipPermission;
    }

    public static IpPermissionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IpPermissionStaxUnmarshaller();
        }
        return instance;
    }
}

