/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Monitoring;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class MonitoringStaxUnmarshaller
implements Unmarshaller<Monitoring, StaxUnmarshallerContext> {
    private static MonitoringStaxUnmarshaller instance;

    public Monitoring unmarshall(StaxUnmarshallerContext context) throws Exception {
        Monitoring monitoring = new Monitoring();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return monitoring;
            }
            if (xmlEvent == 2) {
                if (!context.testExpression("state", targetDepth)) continue;
                monitoring.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return monitoring;
    }

    public static MonitoringStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MonitoringStaxUnmarshaller();
        }
        return instance;
    }
}

