/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PriceSchedule;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class PriceScheduleStaxUnmarshaller
implements Unmarshaller<PriceSchedule, StaxUnmarshallerContext> {
    private static PriceScheduleStaxUnmarshaller instance;

    public PriceSchedule unmarshall(StaxUnmarshallerContext context) throws Exception {
        PriceSchedule priceSchedule = new PriceSchedule();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return priceSchedule;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("term", targetDepth)) {
                    priceSchedule.setTerm(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("price", targetDepth)) {
                    priceSchedule.setPrice(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("currencyCode", targetDepth)) {
                    priceSchedule.setCurrencyCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("active", targetDepth)) continue;
                priceSchedule.setActive(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return priceSchedule;
    }

    public static PriceScheduleStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PriceScheduleStaxUnmarshaller();
        }
        return instance;
    }
}

