/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.RecurringCharge;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class RecurringChargeStaxUnmarshaller
implements Unmarshaller<RecurringCharge, StaxUnmarshallerContext> {
    private static RecurringChargeStaxUnmarshaller instance;

    public RecurringCharge unmarshall(StaxUnmarshallerContext context) throws Exception {
        RecurringCharge recurringCharge = new RecurringCharge();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return recurringCharge;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("frequency", targetDepth)) {
                    recurringCharge.setFrequency(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("amount", targetDepth)) continue;
                recurringCharge.setAmount(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return recurringCharge;
    }

    public static RecurringChargeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecurringChargeStaxUnmarshaller();
        }
        return instance;
    }
}

