/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.RunScheduledInstancesRequest;
import com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import com.amazonaws.services.ec2.model.ScheduledInstancesEbs;
import com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification;
import com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring;
import com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface;
import com.amazonaws.services.ec2.model.ScheduledInstancesPlacement;
import com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RunScheduledInstancesRequestMarshaller
implements Marshaller<Request<RunScheduledInstancesRequest>, RunScheduledInstancesRequest> {
    public Request<RunScheduledInstancesRequest> marshall(RunScheduledInstancesRequest runScheduledInstancesRequest) {
        ScheduledInstancesLaunchSpecification scheduledInstancesLaunchSpecificationLaunchSpecification;
        if (runScheduledInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunScheduledInstances");
        request.addParameter("Version", "2015-10-01");
        if (runScheduledInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)runScheduledInstancesRequest.getClientToken()));
        }
        if (runScheduledInstancesRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)runScheduledInstancesRequest.getInstanceCount()));
        }
        if (runScheduledInstancesRequest.getScheduledInstanceId() != null) {
            request.addParameter("ScheduledInstanceId", StringUtils.fromString((String)runScheduledInstancesRequest.getScheduledInstanceId()));
        }
        if ((scheduledInstancesLaunchSpecificationLaunchSpecification = runScheduledInstancesRequest.getLaunchSpecification()) != null) {
            ScheduledInstancesPlacement scheduledInstancesPlacementPlacement;
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.getImageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationLaunchSpecification.getImageId()));
            }
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.getKeyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationLaunchSpecification.getKeyName()));
            }
            List<String> securityGroupIdsList = scheduledInstancesLaunchSpecificationLaunchSpecification.getSecurityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("LaunchSpecification.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.getUserData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationLaunchSpecification.getUserData()));
            }
            if ((scheduledInstancesPlacementPlacement = scheduledInstancesLaunchSpecificationLaunchSpecification.getPlacement()) != null) {
                if (scheduledInstancesPlacementPlacement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)scheduledInstancesPlacementPlacement.getAvailabilityZone()));
                }
                if (scheduledInstancesPlacementPlacement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)scheduledInstancesPlacementPlacement.getGroupName()));
                }
            }
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.getKernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationLaunchSpecification.getKernelId()));
            }
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationLaunchSpecification.getInstanceType()));
            }
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.getRamdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationLaunchSpecification.getRamdiskId()));
            }
            List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappingsList = scheduledInstancesLaunchSpecificationLaunchSpecification.getBlockDeviceMappings();
            int blockDeviceMappingsListIndex = 1;
            for (ScheduledInstancesBlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                ScheduledInstancesBlockDeviceMapping scheduledInstancesBlockDeviceMappingMember = blockDeviceMappingsListValue;
                if (scheduledInstancesBlockDeviceMappingMember != null) {
                    Object scheduledInstancesEbsEbs;
                    if (scheduledInstancesBlockDeviceMappingMember.getDeviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)scheduledInstancesBlockDeviceMappingMember.getDeviceName()));
                    }
                    if (scheduledInstancesBlockDeviceMappingMember.getNoDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)scheduledInstancesBlockDeviceMappingMember.getNoDevice()));
                    }
                    if (scheduledInstancesBlockDeviceMappingMember.getVirtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)scheduledInstancesBlockDeviceMappingMember.getVirtualName()));
                    }
                    if ((scheduledInstancesEbsEbs = scheduledInstancesBlockDeviceMappingMember.getEbs()) != null) {
                        if (((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getSnapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getSnapshotId()));
                        }
                        if (((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getVolumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getVolumeSize()));
                        }
                        if (((ScheduledInstancesEbs)scheduledInstancesEbsEbs).isDeleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)((ScheduledInstancesEbs)scheduledInstancesEbsEbs).isDeleteOnTermination()));
                        }
                        if (((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getVolumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getVolumeType()));
                        }
                        if (((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getIops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)((ScheduledInstancesEbs)scheduledInstancesEbsEbs).getIops()));
                        }
                        if (((ScheduledInstancesEbs)scheduledInstancesEbsEbs).isEncrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)((ScheduledInstancesEbs)scheduledInstancesEbsEbs).isEncrypted()));
                        }
                    }
                }
                ++blockDeviceMappingsListIndex;
            }
            ScheduledInstancesMonitoring scheduledInstancesMonitoringMonitoring = scheduledInstancesLaunchSpecificationLaunchSpecification.getMonitoring();
            if (scheduledInstancesMonitoringMonitoring != null && scheduledInstancesMonitoringMonitoring.isEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)scheduledInstancesMonitoringMonitoring.isEnabled()));
            }
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)scheduledInstancesLaunchSpecificationLaunchSpecification.getSubnetId()));
            }
            List<ScheduledInstancesNetworkInterface> networkInterfacesList = scheduledInstancesLaunchSpecificationLaunchSpecification.getNetworkInterfaces();
            int networkInterfacesListIndex = 1;
            for (ScheduledInstancesNetworkInterface networkInterfacesListValue : networkInterfacesList) {
                ScheduledInstancesNetworkInterface scheduledInstancesNetworkInterfaceMember = networkInterfacesListValue;
                if (scheduledInstancesNetworkInterfaceMember != null) {
                    if (scheduledInstancesNetworkInterfaceMember.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)scheduledInstancesNetworkInterfaceMember.getNetworkInterfaceId()));
                    }
                    if (scheduledInstancesNetworkInterfaceMember.getDeviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)scheduledInstancesNetworkInterfaceMember.getDeviceIndex()));
                    }
                    if (scheduledInstancesNetworkInterfaceMember.getSubnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)scheduledInstancesNetworkInterfaceMember.getSubnetId()));
                    }
                    if (scheduledInstancesNetworkInterfaceMember.getDescription() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)scheduledInstancesNetworkInterfaceMember.getDescription()));
                    }
                    if (scheduledInstancesNetworkInterfaceMember.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)scheduledInstancesNetworkInterfaceMember.getPrivateIpAddress()));
                    }
                    List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigsList = scheduledInstancesNetworkInterfaceMember.getPrivateIpAddressConfigs();
                    int privateIpAddressConfigsListIndex = 1;
                    for (ScheduledInstancesPrivateIpAddressConfig privateIpAddressConfigsListValue : privateIpAddressConfigsList) {
                        ScheduledInstancesPrivateIpAddressConfig scheduledInstancesPrivateIpAddressConfigMember = privateIpAddressConfigsListValue;
                        if (scheduledInstancesPrivateIpAddressConfigMember != null) {
                            if (scheduledInstancesPrivateIpAddressConfigMember.getPrivateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".PrivateIpAddress", StringUtils.fromString((String)scheduledInstancesPrivateIpAddressConfigMember.getPrivateIpAddress()));
                            }
                            if (scheduledInstancesPrivateIpAddressConfigMember.isPrimary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".Primary", StringUtils.fromBoolean((Boolean)scheduledInstancesPrivateIpAddressConfigMember.isPrimary()));
                            }
                        }
                        ++privateIpAddressConfigsListIndex;
                    }
                    if (scheduledInstancesNetworkInterfaceMember.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)scheduledInstancesNetworkInterfaceMember.getSecondaryPrivateIpAddressCount()));
                    }
                    if (scheduledInstancesNetworkInterfaceMember.isAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)scheduledInstancesNetworkInterfaceMember.isAssociatePublicIpAddress()));
                    }
                    List<String> groupsList = scheduledInstancesNetworkInterfaceMember.getGroups();
                    int groupsListIndex = 1;
                    for (String groupsListValue : groupsList) {
                        if (groupsListValue != null) {
                            request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Group." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
                        }
                        ++groupsListIndex;
                    }
                    if (scheduledInstancesNetworkInterfaceMember.isDeleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)scheduledInstancesNetworkInterfaceMember.isDeleteOnTermination()));
                    }
                }
                ++networkInterfacesListIndex;
            }
            ScheduledInstancesIamInstanceProfile scheduledInstancesIamInstanceProfileIamInstanceProfile = scheduledInstancesLaunchSpecificationLaunchSpecification.getIamInstanceProfile();
            if (scheduledInstancesIamInstanceProfileIamInstanceProfile != null) {
                if (scheduledInstancesIamInstanceProfileIamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString((String)scheduledInstancesIamInstanceProfileIamInstanceProfile.getArn()));
                }
                if (scheduledInstancesIamInstanceProfileIamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString((String)scheduledInstancesIamInstanceProfileIamInstanceProfile.getName()));
                }
            }
            if (scheduledInstancesLaunchSpecificationLaunchSpecification.isEbsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean((Boolean)scheduledInstancesLaunchSpecificationLaunchSpecification.isEbsOptimized()));
            }
        }
        return request;
    }
}

