/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.TagDescription;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class TagDescriptionStaxUnmarshaller
implements Unmarshaller<TagDescription, StaxUnmarshallerContext> {
    private static TagDescriptionStaxUnmarshaller instance;

    public TagDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        TagDescription tagDescription = new TagDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return tagDescription;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("resourceId", targetDepth)) {
                    tagDescription.setResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    tagDescription.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("key", targetDepth)) {
                    tagDescription.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("value", targetDepth)) continue;
                tagDescription.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return tagDescription;
    }

    public static TagDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TagDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

