/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.util;

import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class S3UploadPolicy {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final long ONE_MIN = 60000L;
    private String policySignature;
    private String policyString;

    public S3UploadPolicy(String awsAccessKeyId, String awsSecretKey, String bucketName, String prefix, int expireInMinutes) {
        Date expirationDate = new Date(System.currentTimeMillis() + 60000L * (long)expireInMinutes);
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("\"expiration\": \"").append(DateUtils.format((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (Date)expirationDate)).append("\",").append("\"conditions\": [").append("{\"bucket\": \"").append(bucketName).append("\"},").append("{\"acl\": \"").append("ec2-bundle-read").append("\"},").append("[\"starts-with\", \"$key\", \"").append(prefix).append("\"]").append("]}");
        try {
            this.policyString = this.base64Encode(builder.toString().getBytes(StringUtils.UTF8));
            this.policySignature = this.signPolicy(awsSecretKey, this.policyString);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to generate S3 upload policy", ex);
        }
    }

    public String getPolicyString() {
        return this.policyString;
    }

    public String getPolicySignature() {
        return this.policySignature;
    }

    private String signPolicy(String awsSecretKey, String base64EncodedPolicy) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretKey.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return this.base64Encode(mac.doFinal(base64EncodedPolicy.getBytes()));
    }

    private String base64Encode(byte[] data) {
        return Base64.encodeAsString((byte[])data).replaceAll("\\s", "");
    }
}

