/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.AccessLog;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class AccessLogStaxUnmarshaller
implements Unmarshaller<AccessLog, StaxUnmarshallerContext> {
    private static AccessLogStaxUnmarshaller instance;

    AccessLogStaxUnmarshaller() {
    }

    public AccessLog unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        AccessLog accessLog = new AccessLog();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("Enabled", targetDepth)) {
                    accessLog.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3BucketName", targetDepth)) {
                    accessLog.setS3BucketName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EmitInterval", targetDepth)) {
                    accessLog.setEmitInterval(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("S3BucketPrefix", targetDepth)) continue;
                accessLog.setS3BucketPrefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return accessLog;
    }

    public static AccessLogStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AccessLogStaxUnmarshaller();
        }
        return instance;
    }
}

