/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest;
import com.amazonaws.services.elasticloadbalancing.model.Tag;
import com.amazonaws.services.elasticloadbalancing.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AddTagsRequestMarshaller
implements Marshaller<Request<AddTagsRequest>, AddTagsRequest> {
    public Request<AddTagsRequest> marshall(AddTagsRequest addTagsRequest) {
        String prefix;
        if (addTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AddTagsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addTagsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "AddTags");
        request.addParameter("Version", "2012-06-01");
        if (addTagsRequest.getLoadBalancerNames() != null) {
            prefix = "LoadBalancerNames";
            List<String> loadBalancerNames = addTagsRequest.getLoadBalancerNames();
            int loadBalancerNamesIndex = 1;
            String loadBalancerNamesPrefix = prefix;
            for (String loadBalancerNamesItem : loadBalancerNames) {
                prefix = loadBalancerNamesPrefix + ".member." + loadBalancerNamesIndex;
                if (loadBalancerNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)loadBalancerNamesItem));
                }
                ++loadBalancerNamesIndex;
            }
            prefix = loadBalancerNamesPrefix;
        }
        if (addTagsRequest.getTags() != null) {
            prefix = "Tags";
            List<Tag> tags = addTagsRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            String string = tagsPrefix;
        }
        return request;
    }
}

