/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.transform.HealthCheckStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ConfigureHealthCheckRequestMarshaller
implements Marshaller<Request<ConfigureHealthCheckRequest>, ConfigureHealthCheckRequest> {
    public Request<ConfigureHealthCheckRequest> marshall(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        String prefix;
        if (configureHealthCheckRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ConfigureHealthCheckRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)configureHealthCheckRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ConfigureHealthCheck");
        request.addParameter("Version", "2012-06-01");
        if (configureHealthCheckRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = configureHealthCheckRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (configureHealthCheckRequest.getHealthCheck() != null) {
            prefix = "HealthCheck";
            HealthCheck healthCheck = configureHealthCheckRequest.getHealthCheck();
            HealthCheckStaxMarshaller.getInstance().marshall(healthCheck, (Request<?>)request, prefix + ".");
        }
        return request;
    }
}

