/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class ConnectionSettingsStaxUnmarshaller
implements Unmarshaller<ConnectionSettings, StaxUnmarshallerContext> {
    private static ConnectionSettingsStaxUnmarshaller instance;

    ConnectionSettingsStaxUnmarshaller() {
    }

    public ConnectionSettings unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        ConnectionSettings connectionSettings = new ConnectionSettings();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (!context.testExpression("IdleTimeout", targetDepth)) continue;
                connectionSettings.setIdleTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return connectionSettings;
    }

    public static ConnectionSettingsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectionSettingsStaxUnmarshaller();
        }
        return instance;
    }
}

