/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.transform.InstanceStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeInstanceHealthRequestMarshaller
implements Marshaller<Request<DescribeInstanceHealthRequest>, DescribeInstanceHealthRequest> {
    public Request<DescribeInstanceHealthRequest> marshall(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        String prefix;
        if (describeInstanceHealthRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeInstanceHealthRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceHealthRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeInstanceHealth");
        request.addParameter("Version", "2012-06-01");
        if (describeInstanceHealthRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = describeInstanceHealthRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (describeInstanceHealthRequest.getInstances() != null) {
            prefix = "Instances";
            List<Instance> instances = describeInstanceHealthRequest.getInstances();
            int instancesIndex = 1;
            String instancesPrefix = prefix;
            for (Instance instancesItem : instances) {
                prefix = instancesPrefix + ".member." + instancesIndex;
                if (instancesItem != null) {
                    InstanceStaxMarshaller.getInstance().marshall(instancesItem, (Request<?>)request, prefix + ".");
                }
                ++instancesIndex;
            }
            String string = instancesPrefix;
        }
        return request;
    }
}

