/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeLoadBalancersRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancersRequest>, DescribeLoadBalancersRequest> {
    public Request<DescribeLoadBalancersRequest> marshall(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        String prefix;
        if (describeLoadBalancersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeLoadBalancersRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLoadBalancersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeLoadBalancers");
        request.addParameter("Version", "2012-06-01");
        if (describeLoadBalancersRequest.getLoadBalancerNames() != null) {
            prefix = "LoadBalancerNames";
            List<String> loadBalancerNames = describeLoadBalancersRequest.getLoadBalancerNames();
            int loadBalancerNamesIndex = 1;
            String loadBalancerNamesPrefix = prefix;
            for (String loadBalancerNamesItem : loadBalancerNames) {
                prefix = loadBalancerNamesPrefix + ".member." + loadBalancerNamesIndex;
                if (loadBalancerNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)loadBalancerNamesItem));
                }
                ++loadBalancerNamesIndex;
            }
            prefix = loadBalancerNamesPrefix;
        }
        if (describeLoadBalancersRequest.getMarker() != null) {
            prefix = "Marker";
            String marker = describeLoadBalancersRequest.getMarker();
            request.addParameter(prefix, StringUtils.fromString((String)marker));
        }
        if (describeLoadBalancersRequest.getPageSize() != null) {
            prefix = "PageSize";
            Integer pageSize = describeLoadBalancersRequest.getPageSize();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)pageSize));
        }
        return request;
    }
}

