/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplySecurityGroupsToLoadBalancerRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String loadBalancerName;
    private List<String> securityGroups = new ArrayList<String>();

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public ApplySecurityGroupsToLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public ApplySecurityGroupsToLoadBalancerRequest withSecurityGroups(String ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.securityGroups = new ArrayList<String>(securityGroups.length);
        }
        for (String value : securityGroups) {
            this.securityGroups.add(value);
        }
        return this;
    }

    public ApplySecurityGroupsToLoadBalancerRequest withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySecurityGroupsToLoadBalancerRequest)) {
            return false;
        }
        ApplySecurityGroupsToLoadBalancerRequest other = (ApplySecurityGroupsToLoadBalancerRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        return other.getSecurityGroups() == null || other.getSecurityGroups().equals(this.getSecurityGroups());
    }
}

