/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLoadBalancerListenersRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String loadBalancerName;
    private List<Listener> listeners = new ArrayList<Listener>();

    public CreateLoadBalancerListenersRequest() {
    }

    public CreateLoadBalancerListenersRequest(String loadBalancerName, List<Listener> listeners) {
        this.setLoadBalancerName(loadBalancerName);
        this.setListeners(listeners);
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public CreateLoadBalancerListenersRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        if (listeners == null) {
            this.listeners = null;
            return;
        }
        this.listeners = new ArrayList<Listener>(listeners);
    }

    public CreateLoadBalancerListenersRequest withListeners(Listener ... listeners) {
        if (this.getListeners() == null) {
            this.listeners = new ArrayList<Listener>(listeners.length);
        }
        for (Listener value : listeners) {
            this.listeners.add(value);
        }
        return this;
    }

    public CreateLoadBalancerListenersRequest withListeners(Collection<Listener> listeners) {
        this.setListeners(listeners);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getListeners() != null) {
            sb.append("Listeners: " + this.getListeners());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getListeners() == null ? 0 : this.getListeners().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerListenersRequest)) {
            return false;
        }
        CreateLoadBalancerListenersRequest other = (CreateLoadBalancerListenersRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getListeners() == null ^ this.getListeners() == null) {
            return false;
        }
        return other.getListeners() == null || other.getListeners().equals(this.getListeners());
    }
}

