/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute;
import com.amazonaws.services.elasticloadbalancing.model.transform.PolicyAttributeStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerPolicyRequest>, CreateLoadBalancerPolicyRequest> {
    public Request<CreateLoadBalancerPolicyRequest> marshall(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        String prefix;
        if (createLoadBalancerPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateLoadBalancerPolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerPolicyRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        if (createLoadBalancerPolicyRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = createLoadBalancerPolicyRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (createLoadBalancerPolicyRequest.getPolicyName() != null) {
            prefix = "PolicyName";
            String policyName = createLoadBalancerPolicyRequest.getPolicyName();
            request.addParameter(prefix, StringUtils.fromString((String)policyName));
        }
        if (createLoadBalancerPolicyRequest.getPolicyTypeName() != null) {
            prefix = "PolicyTypeName";
            String policyTypeName = createLoadBalancerPolicyRequest.getPolicyTypeName();
            request.addParameter(prefix, StringUtils.fromString((String)policyTypeName));
        }
        if (createLoadBalancerPolicyRequest.getPolicyAttributes() != null) {
            prefix = "PolicyAttributes";
            List<PolicyAttribute> policyAttributes = createLoadBalancerPolicyRequest.getPolicyAttributes();
            int policyAttributesIndex = 1;
            String policyAttributesPrefix = prefix;
            for (PolicyAttribute policyAttributesItem : policyAttributes) {
                prefix = policyAttributesPrefix + ".member." + policyAttributesIndex;
                if (policyAttributesItem != null) {
                    PolicyAttributeStaxMarshaller.getInstance().marshall(policyAttributesItem, (Request<?>)request, prefix + ".");
                }
                ++policyAttributesIndex;
            }
            String string = policyAttributesPrefix;
        }
        return request;
    }
}

