/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DisableAvailabilityZonesForLoadBalancerRequestMarshaller
implements Marshaller<Request<DisableAvailabilityZonesForLoadBalancerRequest>, DisableAvailabilityZonesForLoadBalancerRequest> {
    public Request<DisableAvailabilityZonesForLoadBalancerRequest> marshall(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) {
        String prefix;
        if (disableAvailabilityZonesForLoadBalancerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DisableAvailabilityZonesForLoadBalancerRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disableAvailabilityZonesForLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DisableAvailabilityZonesForLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        if (disableAvailabilityZonesForLoadBalancerRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = disableAvailabilityZonesForLoadBalancerRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (disableAvailabilityZonesForLoadBalancerRequest.getAvailabilityZones() != null) {
            prefix = "AvailabilityZones";
            List<String> availabilityZones = disableAvailabilityZonesForLoadBalancerRequest.getAvailabilityZones();
            int availabilityZonesIndex = 1;
            String availabilityZonesPrefix = prefix;
            for (String availabilityZonesItem : availabilityZones) {
                prefix = availabilityZonesPrefix + ".member." + availabilityZonesIndex;
                if (availabilityZonesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)availabilityZonesItem));
                }
                ++availabilityZonesIndex;
            }
            String string = availabilityZonesPrefix;
        }
        return request;
    }
}

