/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegisterInstancesWithLoadBalancerRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String loadBalancerName;
    private List<Instance> instances = new ArrayList<Instance>();

    public RegisterInstancesWithLoadBalancerRequest() {
    }

    public RegisterInstancesWithLoadBalancerRequest(String loadBalancerName, List<Instance> instances) {
        this.setLoadBalancerName(loadBalancerName);
        this.setInstances(instances);
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public RegisterInstancesWithLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<Instance>(instances);
    }

    public RegisterInstancesWithLoadBalancerRequest withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.instances = new ArrayList<Instance>(instances.length);
        }
        for (Instance value : instances) {
            this.instances.add(value);
        }
        return this;
    }

    public RegisterInstancesWithLoadBalancerRequest withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstancesWithLoadBalancerRequest)) {
            return false;
        }
        RegisterInstancesWithLoadBalancerRequest other = (RegisterInstancesWithLoadBalancerRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        return other.getInstances() == null || other.getInstances().equals(this.getInstances());
    }
}

