/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateLBCookieStickinessPolicyRequestMarshaller
implements Marshaller<Request<CreateLBCookieStickinessPolicyRequest>, CreateLBCookieStickinessPolicyRequest> {
    public Request<CreateLBCookieStickinessPolicyRequest> marshall(CreateLBCookieStickinessPolicyRequest createLBCookieStickinessPolicyRequest) {
        String prefix;
        if (createLBCookieStickinessPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateLBCookieStickinessPolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLBCookieStickinessPolicyRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLBCookieStickinessPolicy");
        request.addParameter("Version", "2012-06-01");
        if (createLBCookieStickinessPolicyRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = createLBCookieStickinessPolicyRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (createLBCookieStickinessPolicyRequest.getPolicyName() != null) {
            prefix = "PolicyName";
            String policyName = createLBCookieStickinessPolicyRequest.getPolicyName();
            request.addParameter(prefix, StringUtils.fromString((String)policyName));
        }
        if (createLBCookieStickinessPolicyRequest.getCookieExpirationPeriod() != null) {
            prefix = "CookieExpirationPeriod";
            Long cookieExpirationPeriod = createLBCookieStickinessPolicyRequest.getCookieExpirationPeriod();
            request.addParameter(prefix, StringUtils.fromLong((Long)cookieExpirationPeriod));
        }
        return request;
    }
}

