/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.Tag;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerStaxMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        String prefix;
        if (createLoadBalancerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateLoadBalancerRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        if (createLoadBalancerRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = createLoadBalancerRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (createLoadBalancerRequest.getListeners() != null) {
            prefix = "Listeners";
            List<Listener> listeners = createLoadBalancerRequest.getListeners();
            int listenersIndex = 1;
            String listenersPrefix = prefix;
            for (Listener listenersItem : listeners) {
                prefix = listenersPrefix + ".member." + listenersIndex;
                if (listenersItem != null) {
                    ListenerStaxMarshaller.getInstance().marshall(listenersItem, (Request<?>)request, prefix + ".");
                }
                ++listenersIndex;
            }
            prefix = listenersPrefix;
        }
        if (createLoadBalancerRequest.getAvailabilityZones() != null) {
            prefix = "AvailabilityZones";
            List<String> availabilityZones = createLoadBalancerRequest.getAvailabilityZones();
            int availabilityZonesIndex = 1;
            String availabilityZonesPrefix = prefix;
            for (String availabilityZonesItem : availabilityZones) {
                prefix = availabilityZonesPrefix + ".member." + availabilityZonesIndex;
                if (availabilityZonesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)availabilityZonesItem));
                }
                ++availabilityZonesIndex;
            }
            prefix = availabilityZonesPrefix;
        }
        if (createLoadBalancerRequest.getSubnets() != null) {
            prefix = "Subnets";
            List<String> subnets = createLoadBalancerRequest.getSubnets();
            int subnetsIndex = 1;
            String subnetsPrefix = prefix;
            for (String subnetsItem : subnets) {
                prefix = subnetsPrefix + ".member." + subnetsIndex;
                if (subnetsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)subnetsItem));
                }
                ++subnetsIndex;
            }
            prefix = subnetsPrefix;
        }
        if (createLoadBalancerRequest.getSecurityGroups() != null) {
            prefix = "SecurityGroups";
            List<String> securityGroups = createLoadBalancerRequest.getSecurityGroups();
            int securityGroupsIndex = 1;
            String securityGroupsPrefix = prefix;
            for (String securityGroupsItem : securityGroups) {
                prefix = securityGroupsPrefix + ".member." + securityGroupsIndex;
                if (securityGroupsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)securityGroupsItem));
                }
                ++securityGroupsIndex;
            }
            prefix = securityGroupsPrefix;
        }
        if (createLoadBalancerRequest.getScheme() != null) {
            prefix = "Scheme";
            String scheme = createLoadBalancerRequest.getScheme();
            request.addParameter(prefix, StringUtils.fromString((String)scheme));
        }
        if (createLoadBalancerRequest.getTags() != null) {
            prefix = "Tags";
            List<Tag> tags = createLoadBalancerRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            String string = tagsPrefix;
        }
        return request;
    }
}

