/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteLoadBalancerListenersRequestMarshaller
implements Marshaller<Request<DeleteLoadBalancerListenersRequest>, DeleteLoadBalancerListenersRequest> {
    public Request<DeleteLoadBalancerListenersRequest> marshall(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        String prefix;
        if (deleteLoadBalancerListenersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteLoadBalancerListenersRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteLoadBalancerListenersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DeleteLoadBalancerListeners");
        request.addParameter("Version", "2012-06-01");
        if (deleteLoadBalancerListenersRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = deleteLoadBalancerListenersRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (deleteLoadBalancerListenersRequest.getLoadBalancerPorts() != null) {
            prefix = "LoadBalancerPorts";
            List<Integer> loadBalancerPorts = deleteLoadBalancerListenersRequest.getLoadBalancerPorts();
            int loadBalancerPortsIndex = 1;
            String loadBalancerPortsPrefix = prefix;
            for (Integer loadBalancerPortsItem : loadBalancerPorts) {
                prefix = loadBalancerPortsPrefix + ".member." + loadBalancerPortsIndex;
                if (loadBalancerPortsItem != null) {
                    request.addParameter(prefix, StringUtils.fromInteger((Integer)loadBalancerPortsItem));
                }
                ++loadBalancerPortsIndex;
            }
            String string = loadBalancerPortsPrefix;
        }
        return request;
    }
}

