/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<DeleteLoadBalancerPolicyRequest>, DeleteLoadBalancerPolicyRequest> {
    public Request<DeleteLoadBalancerPolicyRequest> marshall(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) {
        String prefix;
        if (deleteLoadBalancerPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteLoadBalancerPolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteLoadBalancerPolicyRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DeleteLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        if (deleteLoadBalancerPolicyRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = deleteLoadBalancerPolicyRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (deleteLoadBalancerPolicyRequest.getPolicyName() != null) {
            prefix = "PolicyName";
            String policyName = deleteLoadBalancerPolicyRequest.getPolicyName();
            request.addParameter(prefix, StringUtils.fromString((String)policyName));
        }
        return request;
    }
}

