/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.BackendServerDescription;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.ListenerDescription;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancing.model.Policies;
import com.amazonaws.services.elasticloadbalancing.model.SourceSecurityGroup;
import com.amazonaws.services.elasticloadbalancing.model.transform.BackendServerDescriptionStaxMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.HealthCheckStaxMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InstanceStaxMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerDescriptionStaxMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.PoliciesStaxMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SourceSecurityGroupStaxMarshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

class LoadBalancerDescriptionStaxMarshaller {
    private static LoadBalancerDescriptionStaxMarshaller instance;

    LoadBalancerDescriptionStaxMarshaller() {
    }

    public void marshall(LoadBalancerDescription _loadBalancerDescription, Request<?> request, String _prefix) {
        String prefix;
        if (_loadBalancerDescription.getLoadBalancerName() != null) {
            prefix = _prefix + "LoadBalancerName";
            String loadBalancerName = _loadBalancerDescription.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (_loadBalancerDescription.getDNSName() != null) {
            prefix = _prefix + "DNSName";
            String dNSName = _loadBalancerDescription.getDNSName();
            request.addParameter(prefix, StringUtils.fromString((String)dNSName));
        }
        if (_loadBalancerDescription.getCanonicalHostedZoneName() != null) {
            prefix = _prefix + "CanonicalHostedZoneName";
            String canonicalHostedZoneName = _loadBalancerDescription.getCanonicalHostedZoneName();
            request.addParameter(prefix, StringUtils.fromString((String)canonicalHostedZoneName));
        }
        if (_loadBalancerDescription.getCanonicalHostedZoneNameID() != null) {
            prefix = _prefix + "CanonicalHostedZoneNameID";
            String canonicalHostedZoneNameID = _loadBalancerDescription.getCanonicalHostedZoneNameID();
            request.addParameter(prefix, StringUtils.fromString((String)canonicalHostedZoneNameID));
        }
        if (_loadBalancerDescription.getListenerDescriptions() != null) {
            prefix = _prefix + "ListenerDescriptions";
            List<ListenerDescription> listenerDescriptions = _loadBalancerDescription.getListenerDescriptions();
            int listenerDescriptionsIndex = 1;
            String listenerDescriptionsPrefix = prefix;
            for (ListenerDescription listenerDescriptionsItem : listenerDescriptions) {
                prefix = listenerDescriptionsPrefix + ".member." + listenerDescriptionsIndex;
                if (listenerDescriptionsItem != null) {
                    ListenerDescriptionStaxMarshaller.getInstance().marshall(listenerDescriptionsItem, request, prefix + ".");
                }
                ++listenerDescriptionsIndex;
            }
            prefix = listenerDescriptionsPrefix;
        }
        if (_loadBalancerDescription.getPolicies() != null) {
            prefix = _prefix + "Policies";
            Policies policies = _loadBalancerDescription.getPolicies();
            PoliciesStaxMarshaller.getInstance().marshall(policies, request, prefix + ".");
        }
        if (_loadBalancerDescription.getBackendServerDescriptions() != null) {
            prefix = _prefix + "BackendServerDescriptions";
            List<BackendServerDescription> backendServerDescriptions = _loadBalancerDescription.getBackendServerDescriptions();
            int backendServerDescriptionsIndex = 1;
            String backendServerDescriptionsPrefix = prefix;
            for (BackendServerDescription backendServerDescriptionsItem : backendServerDescriptions) {
                prefix = backendServerDescriptionsPrefix + ".member." + backendServerDescriptionsIndex;
                if (backendServerDescriptionsItem != null) {
                    BackendServerDescriptionStaxMarshaller.getInstance().marshall(backendServerDescriptionsItem, request, prefix + ".");
                }
                ++backendServerDescriptionsIndex;
            }
            prefix = backendServerDescriptionsPrefix;
        }
        if (_loadBalancerDescription.getAvailabilityZones() != null) {
            prefix = _prefix + "AvailabilityZones";
            List<String> availabilityZones = _loadBalancerDescription.getAvailabilityZones();
            int availabilityZonesIndex = 1;
            String availabilityZonesPrefix = prefix;
            for (String availabilityZonesItem : availabilityZones) {
                prefix = availabilityZonesPrefix + ".member." + availabilityZonesIndex;
                if (availabilityZonesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)availabilityZonesItem));
                }
                ++availabilityZonesIndex;
            }
            prefix = availabilityZonesPrefix;
        }
        if (_loadBalancerDescription.getSubnets() != null) {
            prefix = _prefix + "Subnets";
            List<String> subnets = _loadBalancerDescription.getSubnets();
            int subnetsIndex = 1;
            String subnetsPrefix = prefix;
            for (String subnetsItem : subnets) {
                prefix = subnetsPrefix + ".member." + subnetsIndex;
                if (subnetsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)subnetsItem));
                }
                ++subnetsIndex;
            }
            prefix = subnetsPrefix;
        }
        if (_loadBalancerDescription.getVPCId() != null) {
            prefix = _prefix + "VPCId";
            String vPCId = _loadBalancerDescription.getVPCId();
            request.addParameter(prefix, StringUtils.fromString((String)vPCId));
        }
        if (_loadBalancerDescription.getInstances() != null) {
            prefix = _prefix + "Instances";
            List<Instance> instances = _loadBalancerDescription.getInstances();
            int instancesIndex = 1;
            String instancesPrefix = prefix;
            for (Instance instancesItem : instances) {
                prefix = instancesPrefix + ".member." + instancesIndex;
                if (instancesItem != null) {
                    InstanceStaxMarshaller.getInstance().marshall(instancesItem, request, prefix + ".");
                }
                ++instancesIndex;
            }
            prefix = instancesPrefix;
        }
        if (_loadBalancerDescription.getHealthCheck() != null) {
            prefix = _prefix + "HealthCheck";
            HealthCheck healthCheck = _loadBalancerDescription.getHealthCheck();
            HealthCheckStaxMarshaller.getInstance().marshall(healthCheck, request, prefix + ".");
        }
        if (_loadBalancerDescription.getSourceSecurityGroup() != null) {
            prefix = _prefix + "SourceSecurityGroup";
            SourceSecurityGroup sourceSecurityGroup = _loadBalancerDescription.getSourceSecurityGroup();
            SourceSecurityGroupStaxMarshaller.getInstance().marshall(sourceSecurityGroup, request, prefix + ".");
        }
        if (_loadBalancerDescription.getSecurityGroups() != null) {
            prefix = _prefix + "SecurityGroups";
            List<String> securityGroups = _loadBalancerDescription.getSecurityGroups();
            int securityGroupsIndex = 1;
            String securityGroupsPrefix = prefix;
            for (String securityGroupsItem : securityGroups) {
                prefix = securityGroupsPrefix + ".member." + securityGroupsIndex;
                if (securityGroupsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)securityGroupsItem));
                }
                ++securityGroupsIndex;
            }
            prefix = securityGroupsPrefix;
        }
        if (_loadBalancerDescription.getCreatedTime() != null) {
            prefix = _prefix + "CreatedTime";
            Date createdTime = _loadBalancerDescription.getCreatedTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)createdTime));
        }
        if (_loadBalancerDescription.getScheme() != null) {
            prefix = _prefix + "Scheme";
            String scheme = _loadBalancerDescription.getScheme();
            request.addParameter(prefix, StringUtils.fromString((String)scheme));
        }
    }

    public static LoadBalancerDescriptionStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new LoadBalancerDescriptionStaxMarshaller();
        }
        return instance;
    }
}

