/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.transform.InstanceStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RegisterInstancesWithLoadBalancerRequestMarshaller
implements Marshaller<Request<RegisterInstancesWithLoadBalancerRequest>, RegisterInstancesWithLoadBalancerRequest> {
    public Request<RegisterInstancesWithLoadBalancerRequest> marshall(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) {
        String prefix;
        if (registerInstancesWithLoadBalancerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RegisterInstancesWithLoadBalancerRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerInstancesWithLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RegisterInstancesWithLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        if (registerInstancesWithLoadBalancerRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = registerInstancesWithLoadBalancerRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (registerInstancesWithLoadBalancerRequest.getInstances() != null) {
            prefix = "Instances";
            List<Instance> instances = registerInstancesWithLoadBalancerRequest.getInstances();
            int instancesIndex = 1;
            String instancesPrefix = prefix;
            for (Instance instancesItem : instances) {
                prefix = instancesPrefix + ".member." + instancesIndex;
                if (instancesItem != null) {
                    InstanceStaxMarshaller.getInstance().marshall(instancesItem, (Request<?>)request, prefix + ".");
                }
                ++instancesIndex;
            }
            String string = instancesPrefix;
        }
        return request;
    }
}

