/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest;
import com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly;
import com.amazonaws.services.elasticloadbalancing.model.transform.TagKeyOnlyStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RemoveTagsRequestMarshaller
implements Marshaller<Request<RemoveTagsRequest>, RemoveTagsRequest> {
    public Request<RemoveTagsRequest> marshall(RemoveTagsRequest removeTagsRequest) {
        String prefix;
        if (removeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RemoveTagsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTagsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RemoveTags");
        request.addParameter("Version", "2012-06-01");
        if (removeTagsRequest.getLoadBalancerNames() != null) {
            prefix = "LoadBalancerNames";
            List<String> loadBalancerNames = removeTagsRequest.getLoadBalancerNames();
            int loadBalancerNamesIndex = 1;
            String loadBalancerNamesPrefix = prefix;
            for (String loadBalancerNamesItem : loadBalancerNames) {
                prefix = loadBalancerNamesPrefix + ".member." + loadBalancerNamesIndex;
                if (loadBalancerNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)loadBalancerNamesItem));
                }
                ++loadBalancerNamesIndex;
            }
            prefix = loadBalancerNamesPrefix;
        }
        if (removeTagsRequest.getTags() != null) {
            prefix = "Tags";
            List<TagKeyOnly> tags = removeTagsRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (TagKeyOnly tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagKeyOnlyStaxMarshaller.getInstance().marshall(tagsItem, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            String string = tagsPrefix;
        }
        return request;
    }
}

