/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ApplySecurityGroupsToLoadBalancerRequestMarshaller
implements Marshaller<Request<ApplySecurityGroupsToLoadBalancerRequest>, ApplySecurityGroupsToLoadBalancerRequest> {
    public Request<ApplySecurityGroupsToLoadBalancerRequest> marshall(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) {
        String prefix;
        if (applySecurityGroupsToLoadBalancerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ApplySecurityGroupsToLoadBalancerRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)applySecurityGroupsToLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ApplySecurityGroupsToLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        if (applySecurityGroupsToLoadBalancerRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = applySecurityGroupsToLoadBalancerRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (applySecurityGroupsToLoadBalancerRequest.getSecurityGroups() != null) {
            prefix = "SecurityGroups";
            List<String> securityGroups = applySecurityGroupsToLoadBalancerRequest.getSecurityGroups();
            int securityGroupsIndex = 1;
            String securityGroupsPrefix = prefix;
            for (String securityGroupsItem : securityGroups) {
                prefix = securityGroupsPrefix + ".member." + securityGroupsIndex;
                if (securityGroupsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)securityGroupsItem));
                }
                ++securityGroupsIndex;
            }
            String string = securityGroupsPrefix;
        }
        return request;
    }
}

