/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLoadBalancerListenersRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerListenersRequest>, CreateLoadBalancerListenersRequest> {
    public Request<CreateLoadBalancerListenersRequest> marshall(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) {
        String prefix;
        if (createLoadBalancerListenersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateLoadBalancerListenersRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerListenersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancerListeners");
        request.addParameter("Version", "2012-06-01");
        if (createLoadBalancerListenersRequest.getLoadBalancerName() != null) {
            prefix = "LoadBalancerName";
            String loadBalancerName = createLoadBalancerListenersRequest.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (createLoadBalancerListenersRequest.getListeners() != null) {
            prefix = "Listeners";
            List<Listener> listeners = createLoadBalancerListenersRequest.getListeners();
            int listenersIndex = 1;
            String listenersPrefix = prefix;
            for (Listener listenersItem : listeners) {
                prefix = listenersPrefix + ".member." + listenersIndex;
                if (listenersItem != null) {
                    ListenerStaxMarshaller.getInstance().marshall(listenersItem, (Request<?>)request, prefix + ".");
                }
                ++listenersIndex;
            }
            String string = listenersPrefix;
        }
        return request;
    }
}

