/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        if (describeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeTagsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTagsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2012-06-01");
        if (describeTagsRequest.getLoadBalancerNames() != null) {
            String prefix = "LoadBalancerNames";
            List<String> loadBalancerNames = describeTagsRequest.getLoadBalancerNames();
            int loadBalancerNamesIndex = 1;
            String loadBalancerNamesPrefix = prefix;
            for (String loadBalancerNamesItem : loadBalancerNames) {
                prefix = loadBalancerNamesPrefix + ".member." + loadBalancerNamesIndex;
                if (loadBalancerNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)loadBalancerNamesItem));
                }
                ++loadBalancerNamesIndex;
            }
            String string = loadBalancerNamesPrefix;
        }
        return request;
    }
}

