/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class HealthCheckStaxUnmarshaller
implements Unmarshaller<HealthCheck, StaxUnmarshallerContext> {
    private static HealthCheckStaxUnmarshaller instance;

    HealthCheckStaxUnmarshaller() {
    }

    public HealthCheck unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        HealthCheck healthCheck = new HealthCheck();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("Target", targetDepth)) {
                    healthCheck.setTarget(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Interval", targetDepth)) {
                    healthCheck.setInterval(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timeout", targetDepth)) {
                    healthCheck.setTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UnhealthyThreshold", targetDepth)) {
                    healthCheck.setUnhealthyThreshold(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HealthyThreshold", targetDepth)) continue;
                healthCheck.setHealthyThreshold(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return healthCheck;
    }

    public static HealthCheckStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HealthCheckStaxUnmarshaller();
        }
        return instance;
    }
}

