/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.Tag;
import com.amazonaws.services.elasticloadbalancing.model.TagDescription;
import com.amazonaws.services.elasticloadbalancing.model.transform.TagStaxMarshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

class TagDescriptionStaxMarshaller {
    private static TagDescriptionStaxMarshaller instance;

    TagDescriptionStaxMarshaller() {
    }

    public void marshall(TagDescription _tagDescription, Request<?> request, String _prefix) {
        String prefix;
        if (_tagDescription.getLoadBalancerName() != null) {
            prefix = _prefix + "LoadBalancerName";
            String loadBalancerName = _tagDescription.getLoadBalancerName();
            request.addParameter(prefix, StringUtils.fromString((String)loadBalancerName));
        }
        if (_tagDescription.getTags() != null) {
            prefix = _prefix + "Tags";
            List<Tag> tags = _tagDescription.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, request, prefix + ".");
                }
                ++tagsIndex;
            }
            prefix = tagsPrefix;
        }
    }

    public static TagDescriptionStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new TagDescriptionStaxMarshaller();
        }
        return instance;
    }
}

