/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.iot;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.iot.AWSIotCertificateException;
import com.amazonaws.mobileconnectors.iot.PrivateKeyReader;
import com.amazonaws.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;

public final class AWSIotKeystoreHelper {
    private static final String AWS_IOT_PEM_BEGIN_CERT_TAG = "-----BEGIN CERTIFICATE-----";
    private static final String AWS_IOT_PEM_END_CERT_TAG = "-----END CERTIFICATE-----";
    private static final Integer KEY_LENGTH_BITS = 2048;
    public static final String AWS_IOT_INTERNAL_KEYSTORE_PASSWORD = "awsiotkeystorepassword";

    private AWSIotKeystoreHelper() {
    }

    public static KeyPair generatePrivateAndPublicKeys() {
        KeyPairGenerator keyGen;
        try {
            keyGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("Error creating keypair generator.", e);
        }
        keyGen.initialize(KEY_LENGTH_BITS, new SecureRandom());
        return keyGen.generateKeyPair();
    }

    public static void saveCertificateAndPrivateKey(String certId, String certPem, PrivateKey privKey, String keystorePath, String keystoreName, String keystorePassword) {
        if (certId == null) {
            throw new IllegalArgumentException("certId cannot be null");
        }
        if (certPem == null) {
            throw new IllegalArgumentException("certPem cannot be null");
        }
        if (privKey == null) {
            throw new IllegalArgumentException("privKey cannot be null");
        }
        if (keystorePath == null) {
            throw new IllegalArgumentException("keystorePath cannot be null");
        }
        if (keystoreName == null) {
            throw new IllegalArgumentException("keystoreName cannot be null");
        }
        if (keystorePassword == null) {
            throw new IllegalArgumentException("keystorePassword cannot be null");
        }
        byte[] certBytes = AWSIotKeystoreHelper.parseDERFromPEM(certPem, AWS_IOT_PEM_BEGIN_CERT_TAG, AWS_IOT_PEM_END_CERT_TAG);
        try {
            X509Certificate cert = AWSIotKeystoreHelper.generateCertificateFromDER(certBytes);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            File keystoreFile = new File(keystorePath, keystoreName);
            if (!keystoreFile.exists()) {
                AWSIotKeystoreHelper.createKeystore(keystorePath, keystoreName, keystorePassword);
            }
            FileInputStream fis = new FileInputStream(keystoreFile);
            keystore.load(fis, keystorePassword.toCharArray());
            fis.close();
            keystore.setCertificateEntry(certId, cert);
            keystore.setKeyEntry(certId, privKey, keystorePassword.toCharArray(), new Certificate[]{cert});
            String keystoreFileAndPath = keystorePath.endsWith("/") ? keystorePath + keystoreName : keystorePath + "/" + keystoreName;
            FileOutputStream fos = new FileOutputStream(keystoreFileAndPath);
            keystore.store(fos, keystorePassword.toCharArray());
            fos.close();
        }
        catch (IOException e) {
            throw new AmazonClientException("Error saving certificate and key.", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new AWSIotCertificateException("Error saving certificate and key.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("Error saving certificate and key.", e);
        }
        catch (KeyStoreException e) {
            throw new AWSIotCertificateException("Error saving certificate and key.", e);
        }
    }

    public static void saveCertificateAndPrivateKey(String certId, String certPem, String keyPem, String keystorePath, String keystoreName, String keystorePassword) {
        PrivateKey privateKey;
        PrivateKeyReader privateKeyReader = new PrivateKeyReader(keyPem);
        try {
            privateKey = privateKeyReader.getPrivateKey();
        }
        catch (IOException e) {
            throw new AmazonClientException("An error occurred saving the certificate and key.", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new AWSIotCertificateException("An error occurred saving the certificate and key.", e);
        }
        AWSIotKeystoreHelper.saveCertificateAndPrivateKey(certId, certPem, privateKey, keystorePath, keystoreName, keystorePassword);
    }

    public static KeyStore getIotKeystore(String certId, String keystorePath, String keystoreName, String keyStorePassword) {
        if (certId == null) {
            throw new IllegalArgumentException("certId cannot be null");
        }
        if (keystorePath == null) {
            throw new IllegalArgumentException("keystorePath is null");
        }
        if (keystoreName == null) {
            throw new IllegalArgumentException("keystoreName is null");
        }
        if (keyStorePassword == null) {
            throw new IllegalArgumentException("keystorePassword is null");
        }
        String keystoreFileAndPath = keystorePath.endsWith("/") ? keystorePath + keystoreName : keystorePath + "/" + keystoreName;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(keystoreFileAndPath);
            keyStore.load(fis, keyStorePassword.toCharArray());
            fis.close();
            return AWSIotKeystoreHelper.getTempKeystore(keyStore, certId, keyStorePassword);
        }
        catch (CertificateException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (KeyStoreException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (IOException e) {
            throw new AmazonClientException("Error retrieving certificate and key.", (Throwable)e);
        }
    }

    public static KeyStore getIotKeystore(String certId, InputStream keyStoreInputStream, String keyStorePassword) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
            return AWSIotKeystoreHelper.getTempKeystore(keyStore, certId, keyStorePassword);
        }
        catch (CertificateException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (KeyStoreException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (IOException e) {
            throw new AmazonClientException("Error retrieving certificate and key.", (Throwable)e);
        }
    }

    private static KeyStore getTempKeystore(KeyStore customerKeystore, String certId, String customerKeystorePassword) {
        try {
            KeyStore tempKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
            tempKeystore.load(null);
            X509Certificate cert = (X509Certificate)customerKeystore.getCertificate(certId);
            tempKeystore.setCertificateEntry("cert-alias", cert);
            Key key = customerKeystore.getKey(certId, customerKeystorePassword.toCharArray());
            tempKeystore.setKeyEntry("key-alias", key, AWS_IOT_INTERNAL_KEYSTORE_PASSWORD.toCharArray(), new Certificate[]{cert});
            return tempKeystore;
        }
        catch (CertificateException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (KeyStoreException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (IOException e) {
            throw new AmazonClientException("Error retrieving certificate and key.", (Throwable)e);
        }
    }

    public static Boolean isKeystorePresent(String keystorePath, String keystoreName) {
        File keystoreFile = new File(keystorePath, keystoreName);
        return keystoreFile.exists();
    }

    public static Boolean keystoreContainsAlias(String certId, String keystorePath, String keystoreName, String keystorePassword) {
        Boolean containsAlias = false;
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(keystorePath + "/" + keystoreName);
            keystore.load(fis, keystorePassword.toCharArray());
            if (keystore.containsAlias(certId)) {
                containsAlias = true;
            }
            fis.close();
            return containsAlias;
        }
        catch (CertificateException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (KeyStoreException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (IOException e) {
            throw new AmazonClientException("Error retrieving certificate and key.", (Throwable)e);
        }
    }

    public static void deleteKeystoreAlias(String certId, String keystorePath, String keystoreName, String keystorePassword) {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(keystorePath + "/" + keystoreName);
            keystore.load(fis, keystorePassword.toCharArray());
            fis.close();
            keystore.deleteEntry(certId);
            FileOutputStream fos = new FileOutputStream(keystorePath + "/" + keystoreName);
            keystore.store(fos, keystorePassword.toCharArray());
        }
        catch (CertificateException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (KeyStoreException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AWSIotCertificateException("Error retrieving certificate and key.", e);
        }
        catch (IOException e) {
            throw new AmazonClientException("Error retrieving certificate and key.", (Throwable)e);
        }
    }

    static byte[] parseDERFromPEM(String data, String beginDelimiter, String endDelimiter) {
        String[] tokens = data.split(beginDelimiter);
        tokens = tokens[1].split(endDelimiter);
        return Base64.decode((String)tokens[0]);
    }

    static X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    static void createKeystore(String keystorePath, String keystoreName, String keystorePassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (keystorePath == null) {
            throw new IllegalArgumentException("keystorePath is null");
        }
        if (keystoreName == null) {
            throw new IllegalArgumentException("keystoreName is null");
        }
        if (keystorePassword == null) {
            throw new IllegalArgumentException("keystorePassword is null");
        }
        String keystoreFileAndPath = keystorePath.endsWith("/") ? keystorePath + keystoreName : keystorePath + "/" + keystoreName;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = keystorePassword.toCharArray();
        keyStore.load(null, password);
        FileOutputStream fos = new FileOutputStream(keystoreFileAndPath);
        keyStore.store(fos, password);
        fos.close();
    }
}

