/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.iot;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;

public final class AwsIotEndpointUtility {
    private static final int ENDPOINT_PREFIX_OFFSET = 0;
    private static final int ENDPOINT_IOT_OFFSET = 1;
    private static final int ENDPOINT_REGION_OFFSET = 2;
    private static final int ENDPOINT_DOMAIN_OFFSET = 3;
    private static final int ENDPOINT_TLD_OFFSET = 4;
    private static final int ENDPOINT_SPLIT_SIZE = 5;

    private AwsIotEndpointUtility() {
    }

    private static String stripPort(String endpoint) {
        return endpoint.split(":")[0];
    }

    private static String[] splitEndpoint(String endpoint) {
        return endpoint.split("\\.");
    }

    private static void validateIotEndpoint(String endpoint) {
        String[] splits = AwsIotEndpointUtility.splitEndpoint(endpoint);
        if (!(splits.length == 5 && splits[1].equalsIgnoreCase("iot") && splits[3].equalsIgnoreCase("amazonaws") && splits[4].equalsIgnoreCase("com"))) {
            throw new IllegalArgumentException("Bad endpoint format.  Expected XXXXXX.iot.[region].amazonaws.com.");
        }
    }

    static Region getRegionFromIotEndpoint(String endpoint) {
        String endpointWithoutPort = AwsIotEndpointUtility.stripPort(endpoint);
        AwsIotEndpointUtility.validateIotEndpoint(endpointWithoutPort);
        String[] splits = AwsIotEndpointUtility.splitEndpoint(endpointWithoutPort);
        return Region.getRegion((Regions)Regions.fromName((String)splits[2]));
    }

    static String getAccountPrefixFromEndpont(String endpoint) {
        String endpointWithoutPort = AwsIotEndpointUtility.stripPort(endpoint);
        AwsIotEndpointUtility.validateIotEndpoint(endpointWithoutPort);
        return AwsIotEndpointUtility.splitEndpoint(endpointWithoutPort)[0];
    }
}

