/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.iot.model.Certificate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCertificatesResult
implements Serializable {
    private ListWithAutoConstructFlag<Certificate> certificates;
    private String nextMarker;

    public List<Certificate> getCertificates() {
        if (this.certificates == null) {
            this.certificates = new ListWithAutoConstructFlag();
            this.certificates.setAutoConstruct(true);
        }
        return this.certificates;
    }

    public void setCertificates(Collection<Certificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
            return;
        }
        ListWithAutoConstructFlag certificatesCopy = new ListWithAutoConstructFlag(certificates.size());
        certificatesCopy.addAll(certificates);
        this.certificates = certificatesCopy;
    }

    public ListCertificatesResult withCertificates(Certificate ... certificates) {
        if (this.getCertificates() == null) {
            this.setCertificates(new ArrayList<Certificate>(certificates.length));
        }
        for (Certificate value : certificates) {
            this.getCertificates().add(value);
        }
        return this;
    }

    public ListCertificatesResult withCertificates(Collection<Certificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
        } else {
            ListWithAutoConstructFlag certificatesCopy = new ListWithAutoConstructFlag(certificates.size());
            certificatesCopy.addAll(certificates);
            this.certificates = certificatesCopy;
        }
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListCertificatesResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificates() != null) {
            sb.append("Certificates: " + this.getCertificates() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificates() == null ? 0 : this.getCertificates().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResult)) {
            return false;
        }
        ListCertificatesResult other = (ListCertificatesResult)obj;
        if (other.getCertificates() == null ^ this.getCertificates() == null) {
            return false;
        }
        if (other.getCertificates() != null && !other.getCertificates().equals(this.getCertificates())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        return other.getNextMarker() == null || other.getNextMarker().equals(this.getNextMarker());
    }
}

