/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.iot.model.TopicRuleListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTopicRulesResult
implements Serializable {
    private ListWithAutoConstructFlag<TopicRuleListItem> rules;
    private String nextToken;

    public List<TopicRuleListItem> getRules() {
        if (this.rules == null) {
            this.rules = new ListWithAutoConstructFlag();
            this.rules.setAutoConstruct(true);
        }
        return this.rules;
    }

    public void setRules(Collection<TopicRuleListItem> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        ListWithAutoConstructFlag rulesCopy = new ListWithAutoConstructFlag(rules.size());
        rulesCopy.addAll(rules);
        this.rules = rulesCopy;
    }

    public ListTopicRulesResult withRules(TopicRuleListItem ... rules) {
        if (this.getRules() == null) {
            this.setRules(new ArrayList<TopicRuleListItem>(rules.length));
        }
        for (TopicRuleListItem value : rules) {
            this.getRules().add(value);
        }
        return this;
    }

    public ListTopicRulesResult withRules(Collection<TopicRuleListItem> rules) {
        if (rules == null) {
            this.rules = null;
        } else {
            ListWithAutoConstructFlag rulesCopy = new ListWithAutoConstructFlag(rules.size());
            rulesCopy.addAll(rules);
            this.rules = rulesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListTopicRulesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRules() != null) {
            sb.append("Rules: " + this.getRules() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRulesResult)) {
            return false;
        }
        ListTopicRulesResult other = (ListTopicRulesResult)obj;
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

