/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.iot.model.Action;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TopicRule
implements Serializable {
    private String ruleName;
    private String sql;
    private String description;
    private Date createdAt;
    private ListWithAutoConstructFlag<Action> actions;
    private Boolean ruleDisabled;

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public TopicRule withRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public TopicRule withSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TopicRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public TopicRule withCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new ListWithAutoConstructFlag();
            this.actions.setAutoConstruct(true);
        }
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
        actionsCopy.addAll(actions);
        this.actions = actionsCopy;
    }

    public TopicRule withActions(Action ... actions) {
        if (this.getActions() == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action value : actions) {
            this.getActions().add(value);
        }
        return this;
    }

    public TopicRule withActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
        } else {
            ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
            actionsCopy.addAll(actions);
            this.actions = actionsCopy;
        }
        return this;
    }

    public Boolean isRuleDisabled() {
        return this.ruleDisabled;
    }

    public void setRuleDisabled(Boolean ruleDisabled) {
        this.ruleDisabled = ruleDisabled;
    }

    public TopicRule withRuleDisabled(Boolean ruleDisabled) {
        this.ruleDisabled = ruleDisabled;
        return this;
    }

    public Boolean getRuleDisabled() {
        return this.ruleDisabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleName() != null) {
            sb.append("RuleName: " + this.getRuleName() + ",");
        }
        if (this.getSql() != null) {
            sb.append("Sql: " + this.getSql() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: " + this.getCreatedAt() + ",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: " + this.getActions() + ",");
        }
        if (this.isRuleDisabled() != null) {
            sb.append("RuleDisabled: " + this.isRuleDisabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleName() == null ? 0 : this.getRuleName().hashCode());
        hashCode = 31 * hashCode + (this.getSql() == null ? 0 : this.getSql().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.isRuleDisabled() == null ? 0 : this.isRuleDisabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRule)) {
            return false;
        }
        TopicRule other = (TopicRule)obj;
        if (other.getRuleName() == null ^ this.getRuleName() == null) {
            return false;
        }
        if (other.getRuleName() != null && !other.getRuleName().equals(this.getRuleName())) {
            return false;
        }
        if (other.getSql() == null ^ this.getSql() == null) {
            return false;
        }
        if (other.getSql() != null && !other.getSql().equals(this.getSql())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.isRuleDisabled() == null ^ this.isRuleDisabled() == null) {
            return false;
        }
        return other.isRuleDisabled() == null || other.isRuleDisabled().equals(this.isRuleDisabled());
    }
}

