/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.transform.CloudwatchAlarmActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.CloudwatchMetricActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.DynamoDBActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.ElasticsearchActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.FirehoseActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.KinesisActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.LambdaActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.RepublishActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.S3ActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.SnsActionJsonUnmarshaller;
import com.amazonaws.services.iot.model.transform.SqsActionJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

public class ActionJsonUnmarshaller
implements Unmarshaller<Action, JsonUnmarshallerContext> {
    private static ActionJsonUnmarshaller instance;

    public Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        Action action = new Action();
        AwsJsonReader reader = context.getReader();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("dynamoDB")) {
                action.setDynamoDB(DynamoDBActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("lambda")) {
                action.setLambda(LambdaActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("sns")) {
                action.setSns(SnsActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("sqs")) {
                action.setSqs(SqsActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("kinesis")) {
                action.setKinesis(KinesisActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("republish")) {
                action.setRepublish(RepublishActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("s3")) {
                action.setS3(S3ActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("firehose")) {
                action.setFirehose(FirehoseActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("cloudwatchMetric")) {
                action.setCloudwatchMetric(CloudwatchMetricActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("cloudwatchAlarm")) {
                action.setCloudwatchAlarm(CloudwatchAlarmActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("elasticsearch")) {
                action.setElasticsearch(ElasticsearchActionJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return action;
    }

    public static ActionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ActionJsonUnmarshaller();
        }
        return instance;
    }
}

