/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.CloudwatchAlarmAction;
import com.amazonaws.services.iot.model.CloudwatchMetricAction;
import com.amazonaws.services.iot.model.CreateTopicRuleRequest;
import com.amazonaws.services.iot.model.DynamoDBAction;
import com.amazonaws.services.iot.model.ElasticsearchAction;
import com.amazonaws.services.iot.model.FirehoseAction;
import com.amazonaws.services.iot.model.KinesisAction;
import com.amazonaws.services.iot.model.LambdaAction;
import com.amazonaws.services.iot.model.RepublishAction;
import com.amazonaws.services.iot.model.S3Action;
import com.amazonaws.services.iot.model.SnsAction;
import com.amazonaws.services.iot.model.SqsAction;
import com.amazonaws.services.iot.model.TopicRulePayload;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateTopicRuleRequestMarshaller
implements Marshaller<Request<CreateTopicRuleRequest>, CreateTopicRuleRequest> {
    public Request<CreateTopicRuleRequest> marshall(CreateTopicRuleRequest createTopicRuleRequest) {
        if (createTopicRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTopicRuleRequest, "AWSIot");
        String target = "AWSIotService.CreateTopicRule";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/rules/{ruleName}";
        uriResourcePath = uriResourcePath.replace("{ruleName}", createTopicRuleRequest.getRuleName() == null ? "" : StringUtils.fromString((String)createTopicRuleRequest.getRuleName()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            TopicRulePayload topicRulePayload = createTopicRuleRequest.getTopicRulePayload();
            if (topicRulePayload != null) {
                ListWithAutoConstructFlag actionsList;
                jsonWriter.beginObject();
                if (topicRulePayload.getSql() != null) {
                    jsonWriter.name("sql").value(topicRulePayload.getSql());
                }
                if (topicRulePayload.getDescription() != null) {
                    jsonWriter.name("description").value(topicRulePayload.getDescription());
                }
                if (!((actionsList = (ListWithAutoConstructFlag)topicRulePayload.getActions()) == null || actionsList.isAutoConstruct() && actionsList.isEmpty())) {
                    jsonWriter.name("actions");
                    jsonWriter.beginArray();
                    for (Action actionsListValue : actionsList) {
                        ElasticsearchAction elasticsearch;
                        CloudwatchAlarmAction cloudwatchAlarm;
                        CloudwatchMetricAction cloudwatchMetric;
                        FirehoseAction firehose;
                        S3Action s3;
                        RepublishAction republish;
                        KinesisAction kinesis;
                        SqsAction sqs;
                        SnsAction sns;
                        LambdaAction lambda;
                        if (actionsListValue == null) continue;
                        jsonWriter.beginObject();
                        DynamoDBAction dynamoDB = actionsListValue.getDynamoDB();
                        if (dynamoDB != null) {
                            jsonWriter.name("dynamoDB");
                            jsonWriter.beginObject();
                            if (dynamoDB.getTableName() != null) {
                                jsonWriter.name("tableName").value(dynamoDB.getTableName());
                            }
                            if (dynamoDB.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(dynamoDB.getRoleArn());
                            }
                            if (dynamoDB.getHashKeyField() != null) {
                                jsonWriter.name("hashKeyField").value(dynamoDB.getHashKeyField());
                            }
                            if (dynamoDB.getHashKeyValue() != null) {
                                jsonWriter.name("hashKeyValue").value(dynamoDB.getHashKeyValue());
                            }
                            if (dynamoDB.getRangeKeyField() != null) {
                                jsonWriter.name("rangeKeyField").value(dynamoDB.getRangeKeyField());
                            }
                            if (dynamoDB.getRangeKeyValue() != null) {
                                jsonWriter.name("rangeKeyValue").value(dynamoDB.getRangeKeyValue());
                            }
                            if (dynamoDB.getPayloadField() != null) {
                                jsonWriter.name("payloadField").value(dynamoDB.getPayloadField());
                            }
                            jsonWriter.endObject();
                        }
                        if ((lambda = actionsListValue.getLambda()) != null) {
                            jsonWriter.name("lambda");
                            jsonWriter.beginObject();
                            if (lambda.getFunctionArn() != null) {
                                jsonWriter.name("functionArn").value(lambda.getFunctionArn());
                            }
                            jsonWriter.endObject();
                        }
                        if ((sns = actionsListValue.getSns()) != null) {
                            jsonWriter.name("sns");
                            jsonWriter.beginObject();
                            if (sns.getTargetArn() != null) {
                                jsonWriter.name("targetArn").value(sns.getTargetArn());
                            }
                            if (sns.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(sns.getRoleArn());
                            }
                            if (sns.getMessageFormat() != null) {
                                jsonWriter.name("messageFormat").value(sns.getMessageFormat());
                            }
                            jsonWriter.endObject();
                        }
                        if ((sqs = actionsListValue.getSqs()) != null) {
                            jsonWriter.name("sqs");
                            jsonWriter.beginObject();
                            if (sqs.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(sqs.getRoleArn());
                            }
                            if (sqs.getQueueUrl() != null) {
                                jsonWriter.name("queueUrl").value(sqs.getQueueUrl());
                            }
                            if (sqs.isUseBase64() != null) {
                                jsonWriter.name("useBase64").value(sqs.isUseBase64().booleanValue());
                            }
                            jsonWriter.endObject();
                        }
                        if ((kinesis = actionsListValue.getKinesis()) != null) {
                            jsonWriter.name("kinesis");
                            jsonWriter.beginObject();
                            if (kinesis.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(kinesis.getRoleArn());
                            }
                            if (kinesis.getStreamName() != null) {
                                jsonWriter.name("streamName").value(kinesis.getStreamName());
                            }
                            if (kinesis.getPartitionKey() != null) {
                                jsonWriter.name("partitionKey").value(kinesis.getPartitionKey());
                            }
                            jsonWriter.endObject();
                        }
                        if ((republish = actionsListValue.getRepublish()) != null) {
                            jsonWriter.name("republish");
                            jsonWriter.beginObject();
                            if (republish.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(republish.getRoleArn());
                            }
                            if (republish.getTopic() != null) {
                                jsonWriter.name("topic").value(republish.getTopic());
                            }
                            jsonWriter.endObject();
                        }
                        if ((s3 = actionsListValue.getS3()) != null) {
                            jsonWriter.name("s3");
                            jsonWriter.beginObject();
                            if (s3.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(s3.getRoleArn());
                            }
                            if (s3.getBucketName() != null) {
                                jsonWriter.name("bucketName").value(s3.getBucketName());
                            }
                            if (s3.getKey() != null) {
                                jsonWriter.name("key").value(s3.getKey());
                            }
                            jsonWriter.endObject();
                        }
                        if ((firehose = actionsListValue.getFirehose()) != null) {
                            jsonWriter.name("firehose");
                            jsonWriter.beginObject();
                            if (firehose.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(firehose.getRoleArn());
                            }
                            if (firehose.getDeliveryStreamName() != null) {
                                jsonWriter.name("deliveryStreamName").value(firehose.getDeliveryStreamName());
                            }
                            jsonWriter.endObject();
                        }
                        if ((cloudwatchMetric = actionsListValue.getCloudwatchMetric()) != null) {
                            jsonWriter.name("cloudwatchMetric");
                            jsonWriter.beginObject();
                            if (cloudwatchMetric.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(cloudwatchMetric.getRoleArn());
                            }
                            if (cloudwatchMetric.getMetricNamespace() != null) {
                                jsonWriter.name("metricNamespace").value(cloudwatchMetric.getMetricNamespace());
                            }
                            if (cloudwatchMetric.getMetricName() != null) {
                                jsonWriter.name("metricName").value(cloudwatchMetric.getMetricName());
                            }
                            if (cloudwatchMetric.getMetricValue() != null) {
                                jsonWriter.name("metricValue").value(cloudwatchMetric.getMetricValue());
                            }
                            if (cloudwatchMetric.getMetricUnit() != null) {
                                jsonWriter.name("metricUnit").value(cloudwatchMetric.getMetricUnit());
                            }
                            if (cloudwatchMetric.getMetricTimestamp() != null) {
                                jsonWriter.name("metricTimestamp").value(cloudwatchMetric.getMetricTimestamp());
                            }
                            jsonWriter.endObject();
                        }
                        if ((cloudwatchAlarm = actionsListValue.getCloudwatchAlarm()) != null) {
                            jsonWriter.name("cloudwatchAlarm");
                            jsonWriter.beginObject();
                            if (cloudwatchAlarm.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(cloudwatchAlarm.getRoleArn());
                            }
                            if (cloudwatchAlarm.getAlarmName() != null) {
                                jsonWriter.name("alarmName").value(cloudwatchAlarm.getAlarmName());
                            }
                            if (cloudwatchAlarm.getStateReason() != null) {
                                jsonWriter.name("stateReason").value(cloudwatchAlarm.getStateReason());
                            }
                            if (cloudwatchAlarm.getStateValue() != null) {
                                jsonWriter.name("stateValue").value(cloudwatchAlarm.getStateValue());
                            }
                            jsonWriter.endObject();
                        }
                        if ((elasticsearch = actionsListValue.getElasticsearch()) != null) {
                            jsonWriter.name("elasticsearch");
                            jsonWriter.beginObject();
                            if (elasticsearch.getRoleArn() != null) {
                                jsonWriter.name("roleArn").value(elasticsearch.getRoleArn());
                            }
                            if (elasticsearch.getEndpoint() != null) {
                                jsonWriter.name("endpoint").value(elasticsearch.getEndpoint());
                            }
                            if (elasticsearch.getIndex() != null) {
                                jsonWriter.name("index").value(elasticsearch.getIndex());
                            }
                            if (elasticsearch.getType() != null) {
                                jsonWriter.name("type").value(elasticsearch.getType());
                            }
                            if (elasticsearch.getId() != null) {
                                jsonWriter.name("id").value(elasticsearch.getId());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if (topicRulePayload.isRuleDisabled() != null) {
                    jsonWriter.name("ruleDisabled").value(topicRulePayload.isRuleDisabled().booleanValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

