/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.services.iot.model.KeyPair;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

public class KeyPairJsonUnmarshaller
implements Unmarshaller<KeyPair, JsonUnmarshallerContext> {
    private static KeyPairJsonUnmarshaller instance;

    public KeyPair unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyPair keyPair = new KeyPair();
        AwsJsonReader reader = context.getReader();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("PublicKey")) {
                keyPair.setPublicKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("PrivateKey")) {
                keyPair.setPrivateKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return keyPair;
    }

    public static KeyPairJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairJsonUnmarshaller();
        }
        return instance;
    }
}

