/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPoliciesRequestMarshaller
implements Marshaller<Request<ListPoliciesRequest>, ListPoliciesRequest> {
    public Request<ListPoliciesRequest> marshall(ListPoliciesRequest listPoliciesRequest) {
        if (listPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPoliciesRequest, "AWSIot");
        String target = "AWSIotService.ListPolicies";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies?marker={marker}&pageSize={pageSize}&isAscendingOrder={ascendingOrder}";
        uriResourcePath = uriResourcePath.replace("{marker}", listPoliciesRequest.getMarker() == null ? "" : StringUtils.fromString((String)listPoliciesRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{pageSize}", listPoliciesRequest.getPageSize() == null ? "" : StringUtils.fromInteger((Integer)listPoliciesRequest.getPageSize()));
        uriResourcePath = uriResourcePath.replace("{ascendingOrder}", listPoliciesRequest.isAscendingOrder() == null ? "" : StringUtils.fromBoolean((Boolean)listPoliciesRequest.isAscendingOrder()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

