/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPrincipalPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPrincipalPoliciesRequestMarshaller
implements Marshaller<Request<ListPrincipalPoliciesRequest>, ListPrincipalPoliciesRequest> {
    public Request<ListPrincipalPoliciesRequest> marshall(ListPrincipalPoliciesRequest listPrincipalPoliciesRequest) {
        if (listPrincipalPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPrincipalPoliciesRequest, "AWSIot");
        String target = "AWSIotService.ListPrincipalPolicies";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        if (listPrincipalPoliciesRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-iot-principal", StringUtils.fromString((String)listPrincipalPoliciesRequest.getPrincipal()));
        }
        String uriResourcePath = "/principal-policies?marker={marker}&pageSize={pageSize}&isAscendingOrder={ascendingOrder}";
        uriResourcePath = uriResourcePath.replace("{marker}", listPrincipalPoliciesRequest.getMarker() == null ? "" : StringUtils.fromString((String)listPrincipalPoliciesRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{pageSize}", listPrincipalPoliciesRequest.getPageSize() == null ? "" : StringUtils.fromInteger((Integer)listPrincipalPoliciesRequest.getPageSize()));
        uriResourcePath = uriResourcePath.replace("{ascendingOrder}", listPrincipalPoliciesRequest.isAscendingOrder() == null ? "" : StringUtils.fromBoolean((Boolean)listPrincipalPoliciesRequest.isAscendingOrder()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

